<?php
include_once("funciones.php");
$categorias = unserialize(file_get_contents("private/datos/categorias.txt"));
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta property="og:title" content="<?php echo $title ?>" />
    <meta property="og:description" content="<?php echo $title ?>" />
    <title><?php echo $title; ?></title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css">
    <link rel="stylesheet" href="css.css">

    <script src="https://code.jquery.com/jquery-3.6.4.js" integrity="sha256-a9jBBRygX1Bh5lt8GZjXDzyOB+bWve9EiO7tROUtj/E=" crossorigin="anonymous"></script>
    <script src="js.js"></script>
</head>

<body>

    <header>
        <div id="menu" class="ocultar"><i onclick="vermenu();" class="fa-solid fa-bars"></i></div>
        <div id="logo">
            <img src="imagenes/logo.jpg" alt="Logo">
        </div>
        <div id="buscar">
            <form action="index.php" method="get">
                <input type="search" name="texto" required placeholder="Buscar..." maxlength="50">
                <button class="boton"><span>Buscar</span> <i class="fa-solid fa-magnifying-glass"></i></button>
            </form>
        </div>
    </header>

    <main>
        <nav>
            <ul>
                <?php
                foreach ($categorias as $key => $value) {
                    if ($value[1] > 0) {
                        /* echo '<li><a href="index.php?cat=' . $key . '">' . $value[0] . '</a></li>'; */
                        echo '<li><a href="' . seo_url($value[0]) . '_c_' . $key . '.html">' . $value[0] . '</a></li>';
                    }
                }
                ?>
            </ul>
        </nav>
        <article>