<?php
include_once("php/prohibir.php");
include_once("php/funciones.php");
$title = "Artículos";
$clave = clave(50);
$name = clave(6);
setcookie("awst", $clave, time() + (15 * 60), "/");
setcookie("name", $name, time() + (15 * 60), "/");
?>
<?php include_once("arriba.php"); ?>
<h1><?php echo $title; ?></h1>

<?php
if (isset($_GET['error'])) {
    if ($_GET['error'] == 1) {
        echo '<div class="error"><i class="fa-solid fa-triangle-exclamation"></i> Se ha producido un error</div>';
    } else {
        echo '<div class="ok"><i class="fa-solid fa-circle-check"></i> Operación Válida</div>';
    }
}
?>


<form action="php/nuevoarticulo.php" method="post" enctype="multipart/form-data">
    <fieldset>
        <legend>Nuevo Artículo <button class="botones" onclick="abrirFormulario();" id="botonabrir"> <i class="fa-solid fa-plus"></i> </button></legend>
        <div id="formulario">
            <input type="hidden" name="<?php echo $name ?>" value="<?php echo base64_encode($clave); ?>">
            <input class="input inputancho100" type="text" name="titulo" required class="input input100" placeholder="Título...">
            <textarea name="articulo" id="articulo" placeholder="Texto"></textarea>
            <select class="input inputancho50" name="categoria" required>
                <option value="">Categorías</option>
                <?php
                $categorias = [];
                $categorias = file_get_contents("datos/categorias.txt");
                if ($categorias != "") {
                    $categorias = unserialize($categorias);
                    foreach ($categorias as $key => $value) {
                        echo '<option value="' . $key . '">' . $value[0] . '</option>';
                    }
                }
                ?>
            </select>
            <p>Ficheros Máximo 2MG:</p>
            <input class="input inputancho100" type="file" name="fotos[]" required accept="image/*" multiple>
            <button class="botones"><i class="fa-solid fa-floppy-disk"></i> Crear Artículo</button>
        </div>
    </fieldset>
</form>


<script>
    tinymce.init({
        selector: 'textarea',
        language: 'es',
        plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | emoticons charmap | removeformat',
    });
</script>




<table id="myTable" class="display">
    <thead>
        <tr>
            <th>ID</th>
            <th>Título</th>
            <th>Categoría</th>
            <th>Editar</th>
            <th>Borrar</th>
        </tr>
    </thead>
    <tbody>

        <?php
        $articulos = [];
        $articulos = file_get_contents("datos/articulos.txt");
        $categorias = [];
        $categorias = unserialize(file_get_contents("datos/categorias.txt"));
        if ($articulos != "") {
            $articulos = unserialize($articulos);
            foreach ($articulos as $key => $value) {
                echo '<tr id="fila_' . $key . '">';
                echo '<td>' . $key . '</td>';
                echo '<td>' . $value[0] . '</td>';
                echo '<td>' . $categorias[$value[1]][0] . '</td>';
                echo '<td><a href="editararticulo.php?key=' . $key . '"><i class="fa-solid fa-pen-to-square"></i></a></td>';
                echo '<td><i onclick="borrarArticulo(' . $key . ')" class="fa-solid fa-trash-can"></i></td>';
                echo '</tr>';
            }
        }
        ?>
    </tbody>
</table>

<script>
    let table = new DataTable('#myTable', {
        "language": {
            url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/es-ES.json',
        },
        "pageLength": 100,
        "order": [
            [0, 'desc'],
            [1, 'asc']
        ]
    });

    function borrar(key) {
        if (confirm("Está seguro de borrar esta categoría???")) {
            window.open("php/borrarcategoria.php?key=" + key + "&<?php echo $name; ?>=<?php echo urlencode(base64_encode($clave)); ?>", "_self");
        }
    }
</script>


<?php include_once("abajo.php"); ?>