<?php
$title = "titulo";
$texto = "Texto";
include_once 'simplehtmldom/HtmlWeb.php';

use simplehtmldom\HtmlWeb;

if (isset($_POST['url'])) {

    // Load the page into memory
    $doc = new HtmlWeb();
    $html = $doc->load($_POST['url']);
    //$html->find('div[class="a_s _cf"]', 0)->remove();
    

    // Extract details
    $title = $html->find('title', 0)->plaintext;
    $texto = $html->find('div[class="ue-l-article__body ue-c-article__body"]', 0)->plaintext;


    // Clean up memory
    $html->clear();
    unset($html);
}


?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title></title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Crimson+Text&display=swap');

        body{
            background-color: gray;
            font-family: 'Crimson Text', serif;
        }

        main{
            width: 900px;
            margin: auto;
            background-color: white;
            border: 2px solid black;
            font-size: 1.6em;
            padding: 25px;
            font-weight: 300;
        }
        main p{
            line-height: 1.6em;
        }
    </style>
</head>

<body>
    <form action="b.php" method="post">
        <input type="text" name="url" placeholder="url">
        <input type="submit" value="Enviar">
    </form>


    <main>
        <?php echo '<h1>' . $title . '</h1>' .  mb_convert_encoding(html_entity_decode($texto), "ISO-8859-15", "UTF-8"); ?>
    </main>
</body>

</html>