<?php
$categorias = ['business', 'entertainment', 'general', 'health', 'science', 'sports', 'technology'];
$categoria = 'general';
if (isset($_GET['cat']) && $_GET['cat'] >= 0) {
    $categoria = $categorias[$_GET['cat']];
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $categoria ?></title>
    <link rel="stylesheet" href="css.css">

    <link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

    <script src="https://code.jquery.com/jquery-3.6.0.js"></script>
    <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>

    <script>
        function ver(url) {
            $("#dialog-message").html('<iframe src="'+url+'" frameborder="0"></iframe>');
            $("#dialog-message").dialog({
                modal: true,
                minHeight: 800,
                minWidth: 800,
                buttons: {
                    Ok: function() {
                        $(this).dialog("close");
                    }
                }
            });
        }
    </script>
</head>

<body>

    <header><?php echo $categoria ?></header>
    <main>
        <nav>
            <ul>
                <?php
                foreach ($categorias as $key => $value) {
                    echo "<li><a href='index.php?cat=" . $key . "'>" . $value . "</a></li>";
                }
                ?>
        </nav>
        <section>
            <div id="dialog-message" title="Noticia Completa">
               
            </div>
            <ul class="grilla">
                <?php
                $noticias = [];
                $noticias = unserialize(file_get_contents($categoria . ".txt"));
                foreach ($noticias['articles'] as $key => $value) {
                    echo "<li><h2>" . $value['title'] . "</h2><img src='" . $value['urlToImage'] . "'> <p>" . $value['description'] . "  <button onclick='ver(\"" .  $value['url'] . "\");'>[ + ]</button></p></li>";
                }
                ?>
            </ul>
        </section>
    </main>


</body>

</html>